<?php
/**
 * Class for All in One SEO Pack Override
 *
 * @package WCVendors_Pro
 *
 * @since 1.8.7
 * @version 1.8.7
 */
class WCV_AIOS_Compatibility extends WCV_SEO_Compatibility {
    /**
     * Construct
     *
     * @since 1.8.7
     * @version 1.8.7
     */
    public function __construct() {
        parent::__construct();
        $this->init_hooks();
    }

    /**
     * Init hooks
     *
     * @since 1.8.7
     * @version 1.8.7
     */
    public function init_hooks() {
        add_filter( 'aioseo_disable', array( $this, 'disable_term_output_in_vendor_dashboard' ) );

        if ( $this->is_vendor_store_page ) {
            add_filter( 'aioseo_title', array( $this, 'override_site_title' ), 10, 1 );
            add_filter( 'aioseo_description', array( $this, 'override_store_description' ), 10, 1 );
            add_filter( 'aioseo_facebook_tags', array( $this, 'filter_og_tags' ), 10, 1 );
            add_filter( 'aioseo_twitter_tags', array( $this, 'filter_twitter_tags' ), 10, 1 );
        }

        if ( is_singular( 'product' ) && WCV_Vendors::is_vendor_product( wcv_get_user_role( $this->get_vendor_id() ) ) ) {
            if ( $this->is_og_enable() ) {
                add_filter( 'aioseo_title', array( $this, 'override_product_og_title' ), 10, 1 );
                add_filter( 'aioseo_description', array( $this, 'override_product_og_description' ), 10, 1 );
                if ( $this->is_og_enable() ) {
                    add_filter( 'aioseo_facebook_tags', array( $this, 'filter_og_tags' ), 10, 1 );
                }
                if ( $this->is_twitter_card_enable() ) {
                    add_filter( 'aioseo_twitter_tags', array( $this, 'filter_twitter_tags' ), 10, 1 );
                }
            }
        }
    }

    /**
     * Is enabled
     *
     * @since 1.8.7
     * @version 1.8.7
     *
     * @return bool
     */
    public function is_enable() {
        return is_plugin_active( 'all-in-one-seo-pack/all_in_one_seo_pack.php' ) || is_plugin_active( 'all-in-one-seo-pack-pro/all_in_one_seo_pack.php' );
    }

    /**
     * Disable term output in vendor dashboard
     *
     * @since 1.8.7
     * @version 1.8.7
     *
     * @param bool $disabled Disabled.
     * @return bool
     */
    public function disable_term_output_in_vendor_dashboard( $disabled ) {
        $current_page_id = get_the_ID();

        if ( wcv_is_dashboard_page( $current_page_id ) ) {
            return true;
        }

        return false;
    }

    /**
     * Filter twitter tags
     *
     * @since 1.8.7
     * @version 1.8.7
     *
     * @param array $tw_tags Twitter tags.
     * @return array
     */
    public function filter_twitter_tags( $tw_tags ) {
        $store_tw_tags = $this->get_twitter_tags();
        if ( ! empty( $store_tw_tags ) ) {
            $tw_tags = array_merge( $tw_tags, $store_tw_tags );
        }
        return $tw_tags;
    }

    /**
     * Filter og tags
     *
     * @since 1.8.7
     * @version 1.8.7
     *
     * @param array $og_tabs OG tags.
     *
     * @return array
     */
    public function filter_og_tags( $og_tabs ) {
        $store_og_tabs = $this->get_og_tags();
        if ( ! empty( $store_og_tabs ) ) {
            $og_tabs = array_merge( $og_tabs, $store_og_tabs );
        }
        return $og_tabs;
    }

    /**
     * Get store twitter tags settings
     *
     * @since 1.8.7
     * @version 1.8.7
     *
     * @return array $tw_tags Twitter tags.
     */
    public function get_twitter_tags() {
        $tw_tags = array();
        $tw_site = '@' . $this->override_twitter_site();
        if ( $this->is_vendor_store_page ) {
            $tw_tags = array(
                'twitter:site'        => $tw_site,
                'twitter:creator'     => $tw_site,
                'twitter:title'       => $this->override_store_twitter_title(),
                'twitter:description' => $this->override_store_twitter_description(),
                'twitter:image'       => $this->override_store_twitter_image(),
            );
        }

        if ( $this->is_product_page ) {
            $tw_tags = array(
                'twitter:site'        => $tw_site,
                'twitter:creator'     => $tw_site,
                'twitter:title'       => $this->override_product_twitter_title(),
                'twitter:description' => $this->override_product_twitter_description(),
            );
        }

        return $tw_tags;
    }

    /**
     * Override facebook tags settings
     *
     * @since 1.8.7
     * @version 1.8.7
     *
     * @return array $og_tabs OG tags.
     */
    public function get_og_tags() {
        $og_tabs = array();
        if ( $this->is_vendor_store_page ) {
            $og_tabs = array(
				'og:title'       => $this->override_store_og_title(),
				'og:description' => $this->override_store_og_description(),
				'og:url'         => $this->override_store_og_url(),
				'og:image'       => $this->override_store_og_image(),
                'og:site_name'   => $this->override_site_name_title(),
			);
        }

        if ( $this->is_product_page ) {
            $og_tabs = array(
                'og:title'       => $this->override_product_og_title(),
                'og:description' => $this->override_product_og_description(),
                'og:url'         => $this->override_product_og_url(),
                'og:site_name'   => $this->override_site_name_title(),
            );
        }

        return $og_tabs;
    }

}
new WCV_AIOS_Compatibility();
